﻿/*
USAGE:
	#include "gameProgram/loadgame.as"
	loadGame( "gameName" );
*/
#include "gameFunctions/copyObject.as"
#include "gameProgram/rpgScripts/swf.as"
restoreData = function( loadedData )
{
	var result = false;
	if(loadedData)
	{// if:  there's data to load
		// remove game_mc		(reset SWF storage BEFORE loading a new one)
		ROOT.game_mc.removeMovieClip();
		
		// delete current RAM
		var deleteAllData = function( thisObject )
		{
			for(var nam in thisObject)
			{
				if(typeof(thisObject[nam]) == "object"){
					deleteAllData( thisObject[nam] );		// delete contents
					thisObject[nam] = null;		delete thisObject[nam];		// delete the container
				 }else{
					 thisObject[nam] = null;	delete thisObject[nam];		// delete variable
				 }// if:  typeof object
			}// for:  everything in this object
		}// deleteAllData
		deleteAllData( RAM );
		_global.RAM = {};
		
		// copy data to RAM
		copyObject( loadedData, _global.RAM );
		// initialize any missing data  (pokemon game)
		ROOT.completeRam();
		


		// detect if there's anything in the loaded data
		for(var nam in _global.RAM){
			result = true;
			break;
		}
		
		// restore audio settings
		if(RAM.saveSettings.music.isPlaying){
			MUSIC.play( RAM.saveSettings.music.songName );
		}else{
			MUSIC.songName = RAM.saveSettings.music.songName;
			MUSIC.stop();
		}
		MUSIC.volume = RAM.saveSettings.music.volume;
		MUSIC.songVolume = RAM.saveSettings.music.songVolume;
		SOUND.stopAll();
		SOUND.volume = RAM.saveSettings.sound.volume;
		
		for(var spriteNam in SPRITES){
			SPRITES[spriteNam].onUnload();
		}// for:  each sprite
		
		// load level
		ROOT.loadLevel( RAM.saveSettings.level, RAM.saveSettings.playerPosition );
		
		
		
		// clear previous SWF's
		var removeSwf = function( swfCommand )
		{
			var command_obj = {};
			// populate command_obj
			command_obj.data = {};
			copyObject( swfCommand, command_obj.data );
			command_obj.data.linkage = null;		// Indicate that this SWF should be removed
			var startTime = 0;		// disable the command's 1ms wait fail-safe
			// run command_obj
			define_swf(command_obj);
			command_obj.run( command_obj, true );
		}// removeSwf()
		if(RAM.swfLoader.permSwf==undefined)
			trace("WARNING:  RAM.swfLoader.permSwf is missing!");
		if(RAM.swfLoader.permSwf)
			for(var s=RAM.swfLoader.permSwf.length-1; s>=0; s--)
				removeSwf( RAM.swfLoader.permSwf[s] );
		// temporary SWF's were cleared by loadLevel()
		
		
		// restore SWF's		(SWF commands will be re-called)		(manual alterations in settings via setVariable are NOT preserved!)
		var restoreSwf = function( swfCommand )
		{
			var command_obj = {};
			// populate command_obj
			command_obj.data = {};
			copyObject( swfCommand, command_obj.data );
			// run command_obj
			define_swf(command_obj);
			command_obj.run( command_obj, true );
		}// restoreSwf()
		setTimeout( function()
		{// run after a moment
			for(var s=0; s<RAM.swfLoader.permSwf.length; s++){
				restoreSwf( RAM.swfLoader.permSwf[s] );
			}
			for(var s=0; s<RAM.swfLoader.tempSwf.length; s++){
				restoreSwf( RAM.swfLoader.tempSwf[s] );
			}
		}, 34 );		// run after a moment
		
	}// if:  there's data to load
	return result;
}// restoreData()



loadGame = function( gameId )
{
//	trace("\n loadGame()");
	var gameId = gameId || "humbird0_rpg";
	// access saved data
	var srm = SharedObject.getLocal(gameId);
	
	// report whether any data was loaded
	var result = Boolean(srm.data.ram);
	
	// overwrite RAM  (if load was successful)
	if(result)
		restoreData( srm.data.ram );
	
	return result;
}// loadSave()